<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Your Password</title>
</head>

<body
    style="margin: 0; padding: 0; background-color: #f4f7fa; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif;">

    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="border-collapse: collapse;">
        <tr>
            <td style="padding: 40px 20px;">

                <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                    style="max-width: 600px; margin: 0 auto; border-radius: 14px; background: #ffffff; overflow: hidden; box-shadow: 0px 4px 12px rgba(0,0,0,0.08);">

                    <!-- HEADER -->
                    <tr>
                        <td
                            style="background: linear-gradient(135deg, #c41019 0%, #a00d15 100%); padding: 25px 40px; position: relative; overflow: hidden;">

                            <!-- Decorative Shapes -->
                            <div
                                style="position: absolute; top: -40px; right: -40px; width: 120px; height: 120px; background: rgba(255,255,255,0.08); border-radius: 50%; pointer-events: none;">
                            </div>
                            <div
                                style="position: absolute; bottom: -20px; left: -20px; width: 100px; height: 100px; background: rgba(255,255,255,0.06); border-radius: 50%; pointer-events: none;">
                            </div>
                            <div
                                style="position: absolute; top: 35%; right: 15%; width: 50px; height: 50px; background: rgba(255,255,255,0.05); transform: translateY(-50%) rotate(45deg); pointer-events: none;">
                            </div>

                            <!-- LOGO (Aligned Left Top) -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                style="position: relative; z-index: 1;">
                                <tr>
                                    <td>
                                        <img src="https://cdn.filestackcontent.com/T5eq3WPjRq6tjQ1p3zjZ?nocache="
                                            alt="Hotline.lk Logo"
                                            style="width: 220px; height: auto; margin-bottom: 15px; display: block; filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));">
                                    </td>
                                </tr>
                            </table>

                            <!-- NOTIFICATION ROW -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                style="position: relative; z-index: 1;">
                                <tr>
                                    <td style="text-align: center; padding: 5px 0 0;">

                                        <!-- Lock/Key Icon with Circle Background -->
                                        <div
                                            style="display: inline-block; background: rgba(255,255,255,0.15); border-radius: 50%; padding: 10px; margin-bottom: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.2), 0 0 0 5px rgba(255,255,255,0.08);">
                                            <svg width="40" height="40" viewBox="0 0 24 24" fill="none"
                                                stroke="white" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" style="display: block;">
                                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                            </svg>
                                        </div>

                                        <!-- Heading -->
                                        <div>
                                            <h1
                                                style="margin: 0; color: #ffffff; font-size: 26px; font-weight: 700; letter-spacing: -0.5px; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                                                Reset Your Password
                                            </h1>
                                            <p
                                                style="margin: 5px 0 0; color: rgba(255,255,255,0.9); font-size: 13px; font-weight: 400;">
                                                Secure your account with a new password
                                            </p>
                                        </div>

                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>

                    <!-- CONTENT -->
                    <tr>
                        <td style="padding: 40px;">

                            <p style="font-size: 16px; color: #2d3748; margin: 0 0 20px; line-height: 1.6;">
                                Hello,
                            </p>

                            <p style="font-size: 16px; color: #2d3748; margin: 0 0 28px; line-height: 1.6;">
                                We received a request to reset the password for your <strong>Hotline.lk</strong> account. Click the button below to create a new password.
                            </p>

                            <!-- RESET BUTTON -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                style="margin-bottom: 28px;">
                                <tr>
                                    <td style="text-align: center;">
                                        <a href="<?php echo new \Illuminate\Support\EncodedHtmlString($url); ?>"
                                            style="display: inline-block; padding: 16px 48px; background: linear-gradient(135deg, #c41019 0%, #a00d15 100%); color: #ffffff; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: 600; letter-spacing: 0.5px; box-shadow: 0 4px 12px rgba(196, 16, 25, 0.3);">
                                            Reset Your Password
                                        </a>
                                    </td>
                                </tr>
                            </table>


                            <!-- SECURITY WARNING BOX -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                style="margin-bottom: 20px;">
                                <tr>
                                    <td
                                        style="background-color: #fffbf5; border-left: 4px solid #f59e0b; padding: 16px 20px; border-radius: 6px;">
                                        <p style="margin: 0; color: #92400e; font-size: 14px; line-height: 1.6;">
                                            <strong>🔒 Security Note:</strong> If you didn't request a password reset, please ignore this email. Your password will remain unchanged and your account is secure.
                                        </p>
                                    </td>
                                </tr>
                            </table>

                            <!-- EXPIRY INFO -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0"
                                style="margin-bottom: 25px;">
                                <tr>
                                    <td
                                        style="background-color: #eff6ff; border-left: 4px solid #3b82f6; padding: 16px 20px; border-radius: 6px;">
                                        <p style="margin: 0; color: #1e40af; font-size: 14px; line-height: 1.6;">
                                            <strong>⏱️ Important:</strong> This password reset link will expire in 60 minutes for security purposes. After that, you'll need to request a new one.
                                        </p>
                                    </td>
                                </tr>
                            </table>

                            <!-- TIPS BOX -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td
                                        style="background-color: #f0fdf4; border-left: 4px solid #22c55e; padding: 16px 20px; border-radius: 6px;">
                                        <p style="margin: 0 0 8px; color: #166534; font-size: 13px; font-weight: 600;">
                                            💡 Password Tips:
                                        </p>
                                        <p style="margin: 0; color: #15803d; font-size: 13px; line-height: 1.7;">
                                            • Use at least 8 characters<br>
                                            • Include uppercase and lowercase letters<br>
                                            • Add numbers and special characters<br>
                                            • Avoid common words or personal information
                                        </p>
                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>

                    <!-- FOOTER -->
                     <tr>
                        <td
                            style="background: #fafafa; padding: 28px 40px; text-align: center; border-top: 1px solid #e5e7eb;">
                            <p style="margin: 0; font-size: 13px; color: #6b7280; line-height: 1.5;">
                                This is an automated email. Please do not reply to this message.
                            </p>
                            <p style="margin: 8px 0 0; font-size: 12px; color: #9ca3af;">
                                Hotline.lk · All Rights Reserved
                            </p>
                        </td>
                    </tr>

                </table>

            </td>
        </tr>
    </table>

</body>

</html>
<?php /**PATH /home/hotline/public_html/backend.hotline.lk/resources/views/emails/reset-password.blade.php ENDPATH**/ ?>